; vim: set ts=4 sw=4 sts=4 expandtab: =========================================;
;                  [ 御殿谷サキ from ヴァンガードプリンセス ]                  ;
;==============================================================================;
;==============================================================================;
;                              [ コモンステート ]                              ;
;==============================================================================;
;------------------------------------------------------------------------------;
; Jump Start
;
; sysvar(1) : 方向
; sysvar(4) : ハイジャンプ / 小ジャンプ
;------------------------------------------------------------------------------;
[Statedef 40]
type        = S
movetype    = I
physics     = S
anim        = 40
ctrl        = 0
sprpriority = 1

;-------[ Controls ]-------;

[State 40:          Reset Direction]
type      = VarSet
trigger1  = Time = 0
sysvar(1) = 0

[State 40:          Reset High]
type      = VarSet
trigger1  = Time = 0
sysvar(4) = 0

[State 40:          Var, 1, Forward]
type      = VarSet
trigger1  = command = "holdfwd"
sysvar(1) = 1

[State 40:          Var, 1, Backward]
type      = VarSet
trigger1  = command = "holdback"
sysvar(1) = -1

[State 40:          Var, 2, Low]
type      = VarSet
trigger1  = command != "holdup"
sysvar(4) = -1

[State 40:          Var, 2, High]
type      = VarSet
trigger1  = command = "longjump"
trigger2  = PrevStateNo = 100 && sysvar(1) = 1
sysvar(4) = 1

;-------[ Movement ]-------;

[State 40:          Invincible for Throw]
type     = NotHitBy
trigger1 = 1
value    = SC, NT, ST, HT
time     = 1

[State 40:          Vel, 1, Normal Jump]
type     = VelSet
trigger1 = AnimTime = 0
x        = ifelse(sysvar(1) = 0, const(velocity.jump.neu.x), ifelse(sysvar(1) = 1, const(velocity.jump.fwd.x), const(velocity.jump.back.x))) * ifelse(sysvar(4) = 0, 1.0, ifelse(sysvar(4) > 0, 1.45, 0.75))
y        = const(velocity.jump.y) * ifelse(sysvar(4) = 0, 1.0, ifelse(sysvar(4) > 0, 1.15, 0.75))

[State 40:          Vel, 2, Long Jump]
type     = VelSet
trigger1 = AnimTime = 0
trigger1 = PrevStateNo = 100 && sysvar(1) = 1
x        = const(velocity.runjump.fwd.x)
y        = const(velocity.jump.y) * 0.95

[State 40:          Vel, 3, Dash Back Jump]
type     = VelSet
trigger1 = AnimTime = 0
trigger1 = PrevStateNo = 100 && sysvar(1) = -1
x        = const(velocity.runjump.back.x)

;-------[ States ]-------;

[State 40:          Jump]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 50
ctrl     = 1

;------------------------------------------------------------------------------;
; Jump Up
;------------------------------------------------------------------------------;
[Statedef 50]
type    = A
physics = A

;-------[ Anim ]-------;

[State 50:          Anim, 1, Jump Up Anim]
type     = ChangeAnim
trigger1 = Time = 0
value    = ifelse((Vel X) = 0, 41, ifelse((Vel X) > 0, 42, 43))

[State 50:          Anim, 2, Jump Down Anim]
type       = ChangeAnim
trigger1   = Vel Y > (-8 * fvar(33))
trigger1   = SelfAnimExist(Anim + 3)
trigger1   = Anim >= 41 && Anim <= 43
value      = Anim + 3
persistent = 0

;-------[ Sounds ]-------;

[State 50:          Jump Up SE, 1]
type     = PlaySnd
trigger1 = Time = 0
trigger1 = PrevStateNo != 45
value    = 9, 5 + (sysvar(4) > 0)

[State 50:          Jump Up SE, 2, Air Jump]
type     = PlaySnd
trigger1 = Time = 0
trigger1 = PrevStateNo = 45
value    = 9, 23

;-------[ Effects ]-------;

[State 50:          After Image for Long Jump]
type        = AfterImage
trigger1    = Time = 0
trigger1    = sysvar(4) > 0
time        = 42
palbright   = 1, 1, 1
palcontrast = 128, 128, 128
paladd      = 0, 0, 0
palmul      = 0.5, 0.5, 0.5
length      = 9
trans       = Add1
timegap     = 2
framegap    = 4
persistent  = 0

;-------[ Vars ]-------;

[State 50:          Reset Dir]
type      = VarSet
trigger1  = Time = 0
sysvar(1) = 0

[State 50:          Reset High]
type      = VarSet
trigger1  = Time = 0
sysvar(4) = 0

;------------------------------------------------------------------------------;
; Jump Down (empty state for compatibility)
;------------------------------------------------------------------------------;
[Statedef 51]
type    = A
physics = A
anim    = 51

;-------[ Null ]-------;

[State 51:          Compatibility]
type     = Null
trigger1 = 1

;------------------------------------------------------------------------------;
; Jump Landing
;------------------------------------------------------------------------------;
[Statedef 52]
type     = S
movetype = I
physics  = S
anim     = 47
ctrl     = 0

;-------[ Sounds ]-------;

[State 52:          Landing SE]
type     = PlaySnd
trigger1 = Time = 0
value    = 9, 3

;-------[ Movement ]-------;

[State 52:          Vel, 1, Reset]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 52:          Pos, 1, Reset]
type     = PosSet
trigger1 = Time = 0
y        = 0

[State 52:          Vel, 2, Stop Sliding]
type     = VelSet
;trigger1 = Abs(Vel X) < const(movement.stand.friction.threshold)
trigger1 = Abs(Vel X) < (2.0 * fvar(31))
x        = 0

[State 52:          Ctrl]
type     = CtrlSet
trigger1 = AnimElem = 2
value    = 1

;-------[ Effects ]-------;

[State 52:          Dust]
type        = Explod
trigger1    = Time = 0
anim        = 6201
postype     = p1
pos         = 0, 0
sprpriority = -2
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1

;-------[ States ]-------;

[State 52:          Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 0
ctrl     = 1

;------------------------------------------------------------------------------;
; Run forward
;------------------------------------------------------------------------------;
[Statedef 100]
type        = S
movetype    = I
physics     = S
anim        = 100
sprpriority = 1

;-------[ Sounds ]-------;

[State 100:         Dash SE]
type     = PlaySnd
trigger1 = AnimElem = 6
trigger2 = AnimElem = 12
value    = 9, 11

;-------[ Movement ]-------;

[State 100:         Vel, 1]
type     = VelSet
trigger1 = 1
x        = const(velocity.run.fwd.x)

[State 100:         Prevent run from canceling into walk]
type     = AssertSpecial
trigger1 = 1
flag     = NoWalk

[State 100:         Prevent from turning]
type     = AssertSpecial
trigger1 = 1
flag     = NoAutoTurn

;-------[ Effects ]-------;

[State 100:         Dust, 1]
type        = Explod
trigger1    = Time = 0
anim        = 6213
id          = 6213
postype     = p1
pos         = 0, 0
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1
sprpriority = 1

;-------[ States ]-------;

[State 100:         State, 1, Dash Jump]
type     = ChangeState
trigger1 = command = "holdup"
trigger2 = var(59)
trigger2 = Random < 15
value    = 40

[State 100:         State, 2, Standing]
type     = ChangeState
trigger1 = !var(59)
trigger1 = command != "holdfwd"
trigger2 = var(59)
trigger2 = InGuardDist
trigger2 = Random < 115
trigger3 = var(59)
trigger3 = P2Dist X < 60 * fvar(31)
trigger3 = Random < 115
value    = 0

;------------------------------------------------------------------------------;
; Hop Backwords
;------------------------------------------------------------------------------;
[Statedef 105]
type        = A
movetype    = I
physics     = N
ctrl        = 0
anim        = 105
sprpriority = 1

;-------[ Sounds ]-------;

[State 105:         Jump SE]
type     = PlaySnd
trigger1 = AnimElem = 1
value    = 9, 5

;-------[ Movement ]-------;

[State 105:         Vel, 1, Hop]
type     = VelSet
trigger1 = Time = 0
x        = const(velocity.run.back.x)
y        = const(velocity.run.back.y)

[State 105:         Gravity]
type     = Gravity
trigger1 = 1

;-------[ States ]-------;

[State 105:         State, 1, Landing]
type     = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value    = 106

;------------------------------------------------------------------------------;
; Hop Backwods (Landing)
;------------------------------------------------------------------------------;
[Statedef 106]
type     = S
movetype = I
physics  = S
ctrl     = 0
anim     = 106

;-------[ Sounds ]-------;

[State 106:         Landing SE]
type     = PlaySnd
trigger1 = Time = 0
value    = 9, 3

;-------[ Movement ]-------;

[State 106:         Vel, 1, Reset Gravity]
type     = VelSet
trigger1 = Time = 0
y        = 0

[State 106:         Vel, 2, Stop Sliding]
type     = VelSet
;trigger1 = Abs(Vel X) < const(movement.stand.friction.threshold)
trigger1 = Abs(Vel X) < (2.0 * fvar(31))
x        = 0

[State 106:         Pos, 1, Reset Altitude]
type     = PosSet
trigger1 = Time = 0
y        = 0

;-------[ Effects ]-------;

[State 106:         Dust]
type        = Explod
trigger1    = Time = 0
anim        = 6201
postype     = p1
pos         = 0, 0
sprpriority = -2
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1

;-------[ States ]-------;

[State 106:         State, 1, Standing]
type     = ChangeState
trigger1 = AnimTime = 0
value    = 0
ctrl     = 1

;------------------------------------------------------------------------------;
; Stand guard (guarding)
;------------------------------------------------------------------------------;
[Statedef 130]
type    = S
physics = S



;-------[ Anim ]-------;

[State 130:         Anim, 1]
type     = ChangeAnim
trigger1 = Anim != 130
value    = 130

;-------[ States ]-------;

[State 130:         Change Guard, High to Low]
type     = ChangeState
trigger1 = !var(59)
trigger1 = command = "holddown"
trigger2 = var(59)
trigger2 = P2StateType = C
trigger2 = Random < 65 * (var(59) * 35)
value    = 131

[State 130:         Stop Guarding]
type     = ChangeState
trigger1 = !var(59)
trigger1 = command != "holdback"
trigger2 = !InGuardDist
trigger3 = var(59) && Time > 18
trigger3 = P2MoveType != A
trigger3 = Random < 85 - InGuardDist * 40
trigger4 = var(59)
trigger4 = P2StateType = A
trigger4 = Random < 95 - InGuardDist * 30
trigger5 = var(59)
trigger5 = P2StateType = L
value    = 140

;-------------------------------------------------------------------------------;
; Crouch guard (guarding)
;-------------------------------------------------------------------------------;
[Statedef 131]
type    = C
physics = C


;-------[ Anim ]-------;

[State 130:         Anim, 1]
type     = ChangeAnim
trigger1 = Anim != 131
value    = 131

;-------[ States ]-------;

[State 130:         Change Guard, Low to High]
type     = ChangeState
trigger1 = !var(59)
trigger1 = command != "holddown"
trigger2 = var(59)
trigger2 = P2StateType != C
trigger2 = Random < 65 + (var(59) * 35)
value    = 130

[State 130:         Stop Guarding]
type     = ChangeState
trigger1 = !var(59)
trigger1 = command != "holdback"
trigger2 = !InGuardDist
trigger3 = var(59) && Time > 18
trigger3 = P2MoveType != A
trigger3 = Random < 85 - InGuardDist * 40
trigger4 = var(59)
trigger4 = P2StateType = A
trigger4 = Random < 95 + InGuardDist * 40
trigger5 = var(59)
trigger5 = P2StateType = L
value    = 140

;-------------------------------------------------------------------------------;
; Air guard (guarding)
;-------------------------------------------------------------------------------;
[Statedef 132]
type    = A
physics = N



;-------[ Anim ]-------;

[State 130:         Anim, 1]
type     = ChangeAnim
trigger1 = Anim != 132
value    = 132

;-------[ Movement ]-------;

[State 130:         Vel, 1, Gravity]
type     = VelAdd
trigger1 = 1
y        = Const(movement.yaccel)

[State 130:         Var, 1, Landing Flags]
type      = VarSet
trigger1  = 1
sysvar(0) = (Pos Y >= 0) && (Vel Y > 0)

[State 130:         Vel, 2, Landing]
type     = VelSet
trigger1 = sysvar(0)
y        = 0

[State 130:         Pos, 1, Landing]
type     = PosSet
trigger1 = sysvar(0)
y        = 0

;-------[ States ]-------;

[State 130:         Change Guard, Standing]
type       = ChangeState
triggerall = sysvar(0)
triggerall = InGuardDist
trigger1   = !var(59)
trigger1   = command = "holdback"
trigger2   = var(59)
trigger2   = Random < 345
value      = 130

[State 130:         Landing]
type     = ChangeState
trigger1 = sysvar(0)
value    = 52

[State 130:         Stop Guarding]
type     = ChangeState
trigger1 = !var(59)
trigger1 = command != "holdback"
trigger2 = !InGuardDist
trigger3 = var(59) && Time > 18
trigger3 = P2MoveType != A
trigger3 = Random < 85 - InGuardDist * 40
trigger4 = var(59)
trigger4 = P2StateType = C
trigger4 = Random < 90 + InGuardDist * 40
trigger5 = var(59)
trigger5 = P2StateType = L
value    = 140

;------------------------------------------------------------------------------;
; Stand guard hit (shaking)
;------------------------------------------------------------------------------;
[Statedef 150]
type     = S
movetype = H
physics  = N
velset   = 0, 0






;-------[ Just Defence ]-------;

[State 150:         State, 1, Just Defence]
type       = ChangeState
triggerall = Time = 0
trigger1   = var(19) > 0
value      = 950

;-------[ Anim ]-------;

[State 150:         Anim Freeze]
type     = ChangeAnim
trigger1 = 1
value    = 150

;-------[ States ]-------;

[State 150:         State, 2, Knocked Back]
type     = ChangeState
trigger1 = HitShakeOver
value    = 151 + 2 * (command = "holddown")

;-------[ Movement ]-------;

[State 150:         State Type, 1, High to Low]
type      = StateTypeSet
trigger1  = StateType = S && command = "holddown"
statetype = C
physics   = C

[State 150:         State Type, 2, Low to High]
type      = StateTypeSet
trigger1  = StateType = C && command != "holddown"
statetype = S
physics   = S

[State 150:         Force Feedback]
type     = ForceFeedback
trigger1 = Time = 0
waveform = square
time     = 3

;------------------------------------------------------------------------------;
; Stand guard hit (knocked back)
;------------------------------------------------------------------------------;
[Statedef 151]
type     = S
movetype = H
physics  = S
anim     = 150



;-------[ Movement ]-------;

[State 151:         Vel, 1, Knocked Back]
type     = HitVelSet
trigger1 = Time = 0
trigger1 = PrevStateNo != 950
x        = 1

[State 151:         Vel, 2, Stop Knocked Back]
type     = VelSet
trigger1 = Time = GetHitVar(slidetime)
trigger2 = HitOver
x        = 0

[State 151:         Recovery Ctrl]
type     = CtrlSet
trigger1 = Time = GetHitVar(ctrltime)
value    = 1

[State 151:         State Type, 1, High to Low]
type      = StateTypeSet
trigger1  = StateType = S && command = "holddown"
statetype = C
physics   = C

[State 151:         State Type, 2, Low to High]
type      = StateTypeSet
trigger1  = StateType = C && command != "holddown"
statetype = S
physics   = S

;-------[ States ]-------;

[State 151:         Return Guarding]
type     = ChangeState
trigger1 = HitOver
trigger2 = PrevStateNo = 950
trigger2 = Time >= (GetHitVar(ctrltime) / 2)
value    = 130
ctrl     = 1

;------------------------------------------------------------------------------;
; Crouch guard hit (shaking)
;------------------------------------------------------------------------------;
[Statedef 152]
type     = C
movetype = H
physics  = N
velset   = 0, 0



;-------[ Just Defence ]-------;

[State 152:         State, 1, Just Defence]
type       = ChangeState
triggerall = Time = 0
trigger1   = var(19) > 0
value      = 960

;-------[ Anim ]-------;

[State 152:         Anim Freeze]
type     = ChangeAnim
trigger1 = 1
value    = 151

;-------[ States ]-------;

[State 152:         State, 2, Knocked Back]
type     = ChangeState
trigger1 = HitShakeOver
value    = 151 + 2 * (command = "holddown")

;-------[ Movement ]-------;

[State 152:         State Type, 1, High to Low]
type      = StateTypeSet
trigger1  = StateType = S && command = "holddown"
statetype = C
physics   = C

[State 152:         State Type, 2, Low to High]
type      = StateTypeSet
trigger1  = StateType = C && command != "holddown"
statetype = S
physics   = S

[State 152:         Force Feedback]
type     = ForceFeedback
trigger1 = Time = 0
waveform = square
time     = 4

;------------------------------------------------------------------------------;
; Crouch guard hit (knocked back)
;------------------------------------------------------------------------------;
[Statedef 153]
type     = C
movetype = H
physics  = C
anim     = 151




;-------[ Movement ]-------;

[State 153:         Vel, 1, Knocked Back]
type     = HitVelSet
trigger1 = Time = 0
trigger1 = PrevStateNo != 960
x        = 1

[State 153:         Vel, 2, Stop Knocked Back]
type     = VelSet
trigger1 = Time = GetHitVar(slidetime)
trigger2 = HitOver
x        = 0

[State 153:         Recovery Ctrl]
type     = CtrlSet
trigger1 = Time = GetHitVar(ctrltime)
value    = 1

[State 153:         State Type, 1, High to Low]
type      = StateTypeSet
trigger1  = StateType = S && command = "holddown"
statetype = C
physics   = C

[State 153:         State Type, 2, Low to High]
type      = StateTypeSet
trigger1  = StateType = C && command != "holddown"
statetype = S
physics   = S

;-------[ States ]-------;

[State 153:         Return Guarding]
type     = ChangeState
trigger1 = HitOver
trigger2 = PrevStateNo = 960
trigger2 = Time >= (GetHitVar(ctrltime) / 2)
value    = 131
ctrl     = 1

;------------------------------------------------------------------------------;
; Air guard hit (shaking)
;------------------------------------------------------------------------------;
[Statedef 154]
type     = A
movetype = H
physics  = N
velset   = 0,0



;-------[ Just Defence ]-------;

[State 154:         State, 1, Just Defence]
type       = ChangeState
triggerall = Time = 0
trigger1   = var(19) > 0
value      = 970

;-------[ Anim ]-------;

[State 154:         Anim Freeze]
type     = ChangeAnim
trigger1 = 1
value    = 152

;-------[ States ]-------;

[State 154:         State, 2, Knocked Back]
type     = ChangeState
trigger1 = HitShakeOver
value    = 155 ;AGUARDHIT2

;-------[ Movement ]-------;

[State 154:         Force Feedback]
type     = ForceFeedback
trigger1 = Time = 0
waveform = square
time     = 4

;------------------------------------------------------------------------------;
; Air guard hit (knocked away)
;------------------------------------------------------------------------------;
[Statedef 155]
type     = A
movetype = H
physics  = N
anim     = 152


;-------[ Movement ]-------;

[State 155:         Vel, 1, Knocked Back]
type     = HitVelSet
trigger1 = Time = 0
trigger1 = PrevStateNo != [970, 971]
x        = 1
y        = 1

[State 155:         Vel, 2, Gravity]
type     = VelAdd
trigger1 = 1
y        = const(movement.yaccel)

[State 155:         Recovery Ctrl]
type     = CtrlSet
trigger1 = Time = GetHitVar(ctrltime)
value    = 1

[State 155:         Var, 1, Landing Flag]
type      = VarSet
trigger1  = 1
sysvar(0) = (Pos Y >= 0) && (Vel Y > 0)

[State 155:         Vel, 3, Reset (Landing)]
type     = VelSet
trigger1 = sysvar(0)
y        = 0

[State 155:         Pos, 1, Reset (Landing)]
type     = PosSet
trigger1 = sysvar(0)
y        = 0

;-------[ States ]-------;

[State 155:         State, 1, Just Defence]
type     = ChangeState
trigger1 = !sysvar(0)
trigger1 = PrevStateNo = [970, 971]
trigger1 = Time >= (GetHitVar(ctrltime) / 2)
value    = 132

[State 155:         State, 2, Stand Guarding]
type     = ChangeState
trigger1 = sysvar(0)
trigger1 = command = "holdback"
trigger1 = InGuardDist
value    = 130

[State 155:         State, 3, Landing]
type     = ChangeState
trigger1 = sysvar(0)
value    = 52


;==============================================================================;
;                             [ 常時監視ステート ]                             ;
;==============================================================================;
;==============================================================================;
; 常時監視ステート -2
;------------------------------------------------------------------------------;
; 1. 時間停止中は実行されない
; 2. 相手にステートを奪われていても実行される
; 3. Player扱いのヘルパーが参照する
;==============================================================================;
[Statedef -2]

;==============================================================================;
; 消費ゲージ量
;==============================================================================;
[State -1:          Set Hyper Combo Gauge Value]
type     = VarSet
trigger1 = !IsHelper
v        = 1
value    = ifelse(var(20) > 0, PowerMax + 1, 1000)  ; 通常1ゲージ, MAX時使用不可

[State -1:          Set MAX Hyper Combo Gauge Value]
type     = VarSet
trigger1 = !IsHelper
v        = 2
value    = ifelse(var(20) > 0, 1000, 3000)          ; 通常3ゲージ, MAX時1ゲージ

;[State -1:          Set Guard-Cancel Moves Gauge Value]
;type     = VarSet
;trigger1 = !IsHelper
;v        = 5
;value    = ifelse(var(20) > 0, 0, 1000)             ; 通常1ゲージ, MAX時消費なし

;==============================================================================;
; 相手位置
;==============================================================================;
[State -1:          Enemy Direction]
type           = VarSet
trigger1       = !IsHelper
trigger1       = P2BodyDist X = 0
fv             = 30
value          = 90.0
ignorehitpause = 1

[State -1:          Enemy Direction]
type           = VarSet
trigger1       = !IsHelper
trigger1       = P2BodyDist X != 0
fv             = 30
value          = (Atan((P2BodyDist Y) / (P2BodyDist X)) * 180 / PI)
ignorehitpause = 1

[State -1:          EnemyNear ID]
type           = VarSet
trigger1       = !IsHelper
trigger1       = NumEnemy
v              = 35
value          = EnemyNear((EnemyNear(0),Alive = 0) && (NumEnemy > 1)),ID
ignorehitpause = 1

[State -2:          Enemy Hit Count Reset]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PlayerIDExist(var(35))
trigger1       = PlayerID(var(35)),MoveType != H
trigger2       = PlayerIDExist(var(35))
trigger2       = PlayerID(var(35)),MoveType = H
trigger2       = PlayerID(var(35)),StateNo = [120, 155]
trigger3       = !PlayerIDExist(var(35))
v              = 36
value          = 0
ignorehitpause = 1

[State -2:          Enemy Hit Count]
type           = VarSet
triggerall     = !IsHelper
triggerall     = PlayerIDExist(var(35))
trigger1       = PlayerID(var(35)),MoveType = H
v              = 36
value          = PlayerID(var(35)),GetHitVar(HitCount)
ignorehitpause = 1

;==============================================================================;
; サウンド
;==============================================================================;
;------------------------------------------------------------------------------;
; 食らいボイス
;------------------------------------------------------------------------------;
[State -2:          Get Hit Voice]
type           = PlaySnd
triggerall     = !IsHelper
triggerall     = Alive
triggerall     = StateNo = 5000 || StateNo = 5010 || StateNo = 5020 || StateNo = 5070 || StateNo = 5080
triggerall     = Time = 1
trigger1       = GetHitVar(AnimType) >= 2 && Random < 500
trigger2       = GetHitVar(AnimType) < 2 && Random < 300
value          = 0, ifelse(GetHitVar(AnimType) < 4, 5000 + GetHitVar(AnimType), 5005)
channel        = 0
lowpriority    = 1
ignorehitpause = 1
persistent     = 0

;------------------------------------------------------------------------------;
; 復帰ボイス
;------------------------------------------------------------------------------;
[State -2:          Get Up Voice]
type        = PlaySnd
triggerall  = Alive
triggerall  = Time = 1
trigger1    = StateNo = 5040 && Random < 450
trigger2    = StateNo = 5120
value       = 0, 5120
channel     = 0
lowpriority = 1
persistent  = 0

[State -2:          Recovery Voice]
type        = PlaySnd
triggerall  = Alive
triggerall  = Time = 1
trigger1    = StateNo = 5201
trigger2    = StateNo = 5210
value       = 0, 5200
channel     = 0
lowpriority = 0
persistent  = 0

;------------------------------------------------------------------------------;
; ダッシュ 停止
;------------------------------------------------------------------------------;
[State -2:          Start Dash Flag]
type       = VarSet
triggerall = !IsHelper
triggerall = Alive
triggerall = !sysvar(3)
trigger1   = StateNo = 100
sysvar(3)  = 1

[State -2:          Stop Dash]
type       = PlaySnd
triggerall = !IsHelper
triggerall = Alive
triggerall = PrevStateNo = 100
triggerall = StateNo != 100
triggerall = StateNo != 40
trigger1   = sysvar(3)
value      = 9, 7

;==============================================================================;
; エフェクト
;==============================================================================;
;------------------------------------------------------------------------------;
; ダッシュ停止エフェクト
;------------------------------------------------------------------------------;
[State -2:          Dust]
type        = Explod
triggerall  = !IsHelper
triggerall  = Alive
triggerall  = PrevStateNo = 100
triggerall  = StateNo != 100
triggerall  = StateNo != 40
trigger1    = sysvar(3)
anim        = 6202
postype     = p1
pos         = 2, 0
sprpriority = 5
scale       = const(size.xscale), const(size.yscale)
ownpal      = 1

[State -2:          Stop Dash Flag]
type       = VarSet
triggerall = !IsHelper
triggerall = sysvar(3)
trigger1   = PrevStateNo = 100
trigger1   = StateNo != 100
trigger1   = StateNo != 40
trigger2   = !Alive
trigger3   = MoveType = H
sysvar(3)  = 0

;==============================================================================;
; キャンセルフラグ
;==============================================================================;
;------------------------------------------------------------------------------;
; チェーンコンボ
;------------------------------------------------------------------------------;
[State -2:          Reset Chain]
type       = VarSet
triggerall = !IsHelper
triggerall = var(10)
trigger1   = StateNo != 200
trigger1   = StateNo != 205
trigger1   = StateNo != 210
trigger1   = StateNo != 215
trigger1   = StateNo != 220
trigger1   = StateNo != 400
trigger1   = StateNo != 405
trigger1   = StateNo != 410
trigger1   = StateNo != 420
trigger1   = StateNo != [600, 601]
trigger1   = Stateno != 610
trigger1   = StateNo != 620
trigger2   = StateNo = 200 && AnimElemTime(3) < 0
trigger3   = StateNo = 205 && AnimElemTime(4) < 0
trigger4   = StateNo = 210 && AnimElemTime(6) < 0
trigger5   = StateNo = 215 && AnimElemTime(7) < 0
trigger6   = StateNo = 220 && AnimElemTime(5) < 0
trigger7   = StateNo = 400 && AnimElemTime(3) < 0
trigger8   = StateNo = 405 && AnimElemTime(5) < 0
trigger9   = StateNo = 410 && AnimElemTime(4) < 0
trigger10  = StateNo = 420 && AnimElemTime(4) < 0
trigger11  = StateNo = 600 && AnimElemTime(3) < 0
trigger12  = StateNo = 610 && AnimElemTime(3) < 0
trigger13  = StateNo = 620 && AnimElemTime(5) < 0
v          = 10
value      = 0

[State -2:          Set Chain Lv.1]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 200 && MoveContact && AnimElemTime(4) >= 0
trigger2   = StateNo = 400 && MoveContact && AnimElemTime(4) >= 0
trigger3   = StateNo = 600 && MoveContact && AnimElemTime(3) >= 0
v          = 10
value      = 1

[State -2:          Set Chain Lv.2]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 205 && MoveContact && AnimElemTime(6) >= 0
trigger2   = StateNo = 405 && MoveContact && AnimElemTime(9) >= 0
v          = 10
value      = 2

[State -2:          Set Chain Lv.3]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 210 && MoveContact && AnimElemTime(8) >= 0
trigger2   = StateNo = 410 && MoveContact && AnimElemTime(6) >= 0
trigger3   = StateNo = 610 && MoveContact && AnimElemTime(4) >= 0
v          = 10
value      = 3

[State -2:          Set Chain Lv.4]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 215 && MoveContact && AnimElemTime(10) >= 0
v          = 10
value      = 4

[State -2:          Set Chain Lv.5]
type       = VarSet
triggerall = !IsHelper
trigger1   = StateNo = 220 && MoveContact && AnimElemTime(8) >= 0
trigger2   = StateNo = 420 && MoveContact && AnimElemTime(6) >= 0
trigger3   = StateNo = 620 && MoveContact && AnimElemTime(7) >= 0
v          = 10
value      = 5

;==============================================================================;
; ジャストディフェンス
;==============================================================================;
;------------------------------------------------------------------------------;
; ジャストディフェンス受付
;------------------------------------------------------------------------------;
[State -2:          Reset Just Defence Time]
type       = VarSet
triggerall = !IsHelper
triggerall = var(19) = 0
trigger1   = command != "holdback"
v          = 19
value      = -1

[State -2:          Set Just Defence Time]
type       = VarSet
triggerall = !IsHelper
triggerall = var(19) < 0
trigger1   = StateNo = 120
v          = 19
value      = 7

[State -2:          Count Down Just Defence Time]
type       = VarAdd
triggerall = !IsHelper
trigger1   = var(19) > 0
v          = 19
value      = -1

;==============================================================================;
; 攻撃力補正計算
;==============================================================================;
;------------------------------------------------------------------------------;
; 基本1 Const(data.attack) の補正 (TargetLifeAdd用)
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by data.attack]
type           = VarSet
trigger1       = !IsHelper
fv             = 0
value          = Const(data.attack) * 0.01
ignorehitpause = 1

;------------------------------------------------------------------------------;
; モードによる補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction]
type           = VarSet
triggerall     = !IsHelper
trigger1       = 1
fv             = 1
value          = 1.0
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 特殊カラー補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by Normal Color]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PalNo != 12
fv             = 2
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by Gold Color]
type           = VarSet
triggerall     = !IsHelper
trigger1       = PalNo = 12
fv             = 2
value          = 1.50
ignorehitpause = 1

;------------------------------------------------------------------------------;
; MAX補正
;------------------------------------------------------------------------------;
[State -2:          Reset Attack Correction by MAX]
type           = VarSet
triggerall     = !IsHelper
trigger1       = var(20) <= 0
fv             = 3
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by MAX]
type           = VarSet
triggerall     = !IsHelper
trigger1       = var(20) > 0
fv             = 3
value          = 1.2
ignorehitpause = 1

;------------------------------------------------------------------------------;
; ライフ補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by Life, 0]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life > Ceil(LifeMax * 0.3)
fv             = 4
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by Life, 1]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.3)
trigger1       = Life > Ceil(LifeMax * 0.15)
fv             = 4
value          = 1.05
ignorehitpause = 1

[State -2:          Attack Correction by Life, 2]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.15)
fv             = 4
value          = 1.1
ignorehitpause = 1

;------------------------------------------------------------------------------;
; コンボ補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction by No Combo]
type           = VarSet
triggerall     = !IsHelper
trigger1       = var(55) > 0
trigger1       = var(36) <= (var(55) - 1)
trigger2       = var(55) <= 0
fv             = 15
value          = 1.0
ignorehitpause = 1

[State -2:          Attack Correction by Combo]
type           = VarSet
triggerall     = !IsHelper
triggerall     = var(55) > 0
trigger1       = var(36) > (var(55) - 1)
fv             = 15
value          = 1.0 * (fvar(38) ** (var(36) - (var(55) - 1)))
ignorehitpause = 1

;==============================================================================;
; 防御力補正計算
;==============================================================================;
;------------------------------------------------------------------------------;
; 落下時補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction by Hit Fall]
type           = VarSet
triggerall     = !IsHelper
trigger1       = HitFall
fv             = 5
value          = Const(data.fall.defence_mul)
ignorehitpause = 1

[State -2:          Defence Correction by Not Hit Fall]
type           = VarSet
triggerall     = !IsHelper
trigger1       = !HitFall
fv             = 5
value          = 1.0
ignorehitpause = 1

;------------------------------------------------------------------------------;
; モード補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction (Default)]
type           = VarSet
triggerall     = !IsHelper
trigger1       = 1
fv             = 6
value          = 1.3334
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 特殊カラー補正
;------------------------------------------------------------------------------;
;[State -2:          Defence Correction (Gold)]
;type           = VarSet
;triggerall     = !IsHelper
;trigger1       = var(54) = 3
;fv             = 6
;value          = 1.3335
;ignorehitpause = 1

;------------------------------------------------------------------------------;
; ライフ補正
;------------------------------------------------------------------------------;
[State -2:          Defenfce Correction by Life, 0]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life > Ceil(LifeMax * 0.3)
fv             = 7
value          = 1.0
ignorehitpause = 1

[State -2:          Defenfce Correction by Life, 1]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.3)
trigger1       = Life > Ceil(LifeMax * 0.15)
fv             = 7
value          = 0.9
ignorehitpause = 1

[State -2:          Defenfce Correction by Life, 2]
type           = VarSet
triggerall     = !IsHelper
trigger1       = Life <= Ceil(LifeMax * 0.15)
fv             = 7
value          = 0.75
ignorehitpause = 1

;==============================================================================;
; 補正反映
;==============================================================================;
;------------------------------------------------------------------------------;
; 攻撃力補正
;------------------------------------------------------------------------------;
[State -2:          Attack Correction for Attack Mul]
type           = VarSet
trigger1       = !IsHelper
fv             = 10
value          = fvar(1) * fvar(2) * fvar(3) * fvar(4) * fvar(15)
ignorehitpause = 1

[State -2:          Attack Correction]
type           = AttackMulSet
trigger1       = !IsHelper
value          = fvar(10)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; TargetLifeAdd用
;------------------------------------------------------------------------------;
[State -2:          Attack Correction for LifeAdd]
type           = VarSet
trigger1       = !IsHelper
fv             = 11
value          = fvar(0) * fvar(10)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 防御力補正
;------------------------------------------------------------------------------;
[State -2:          Defence Correction for Defefnce Mul]
type           = VarSet
trigger1       = !IsHelper
fv             = 12
value          = fvar(5) * fvar(6) * fvar(7)
ignorehitpause = 1

[State -2:          Defence Correction]
type           = DefenceMulSet
trigger1       = !IsHelper
value          = fvar(12)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; GetHitVar(hitcount)
;------------------------------------------------------------------------------;
[State -2:          Hit Count Reset]
type           = VarSet
triggerall     = !IsHelper
trigger1       = MoveType != H
trigger2       = StateNo = [120, 159]
v              = 33
value          = 0
ignorehitpause = 1

[State -2:          Hit Count]
type           = VarSet
triggerall     = !IsHelper
trigger1       = MoveType = H
trigger1       = StateNo != [120, 159]
v              = 33
value          = GetHitVar(HitCount)
ignorehitpause = 1

;------------------------------------------------------------------------------;
; 一撃目補正
;------------------------------------------------------------------------------;
[State -2:          Calc First Get Hit Damage]
type           = LifeAdd
triggerall     = Alive
triggerall     = var(33) = 1
triggerall     = var(31) := GetHitVar(Damage)
trigger1       = var(30) := Floor(var(31) * (1.0 - (fvar(6) * fvar(7))))
value          = var(30)
absolute       = 1
persistent     = 0
ignorehitpause = 1

;==============================================================================;
; サポート
;==============================================================================;
;------------------------------------------------------------------------------;
; サポートゲージ
;------------------------------------------------------------------------------;
[State -2:          Descendent Support Counter Time]
type       = VarAdd
triggerall = !IsHelper
triggerall = !NumHelper(6500)
trigger1   = var(26) > 0
v          = 26
value      = -1


[State -2:          Support Counter]
type       = VarSet
triggerall = !IsHelper
trigger1   = var(26) > 0
trigger1   = var(25) > 0
trigger2=stateno=[5000,5059]
trigger2=stateno=[var(59),var(59)+300]
v          = 25
value      = 0

[State -2:          Level, Recover]
type       = VarAdd
triggerall = !IsHelper
triggerall = RoundState = 2
triggerall = !NumHelper(6500)
triggerall = var(26) <= 0
trigger1   = var(25) < 500
v          = 25
value      = 1

[State -2:          Level Max]
type       = VarSet
triggerall = !IsHelper
trigger1   = var(25) > 500
v          = 25
value      = 500

[State -2:          Level, Set]
type       = VarSet
triggerall = !IsHelper
trigger1   = RoundState = 1
trigger1   = var(25) < 100
v          = 25
value      = 100

;==============================================================================;
; 獣を焦がす対応
;
; 常時監視ステート (-1、-2、-3のどれか) に以下の記述を追加しておくと、
; ウチの秋葉が出した獣を焦がすの設置に反応して体力・パワーが減ります。
;
; ※1 ウチの秋葉はvar(39)に獣を焦がすの設置ヘルパーの「Player ID」を
;     格納するようにしたので、そのIDを元にPlayerIDリダイレクトで場所を取得、
;     その前後85以内にいるときに処理をするようにしてください
; ※2 下の記述ではsize.xscaleによる横幅変更に対応しようとしています。
; ※3 var(39)の内容は、
;     var(39) = -1      : 設置されていない
;     var(39) >= 0      : ヘルパーの Player ID
; ※4 変化量を調整したい場合は
;     ・GameTime % 2 のトリガーを弄る (何Fおきに処理するか)
;     ・valueの値を変更する           (一度にどれだけ変化するか)
;     をすればよいです。
; ※5 とりあえず設置ヘルパーの上にいるときになんらかの処理が出来ればいいので、
;     トリガーとかは適当に調整してください。
;==============================================================================;
[State -2:          Life]
type       = LifeAdd
triggerall = !IsHelper                  ; 本体限定
triggerall = RoundState = 2 && Alive    ; 試合中 かつ 生きている
triggerall = StateType != A             ; 地上にいる
triggerall = GameTime % 3 = 0           ; 3Fおきに処理
triggerall = NumEnemy                   ; 敵がいる
trigger1   = Enemy(0),AuthorName = "chikuchikugonzalez" && Enemy(0),Name = "Tohno Akiha"        ; 1P (or 2P) が秋葉
trigger1   = Enemy(0),var(39) >= 0                                                              ; IDが格納されている (格納されていない場合は -1)
trigger1   = PlayerIDExist(Enemy(0),var(39))                                                    ; 格納IDのキャラクター or Helperが存在する
trigger1   = Abs(PlayerID(Enemy(0),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(0),var(39)),const(size.xscale))       ; 相手の前後85以内
trigger2   = NumEnemy > 1                                                                       ; 相手がタッグ
trigger2   = Enemy(1),AuthorName = "chikuchikugonzalez" && Enemy(1),Name = "Tohno Akiha"        ; 3P (or 4P) が秋葉
trigger2   = Enemy(1),var(39) >= 0                                                              ; IDが格納されている
trigger2   = PlayerIDExist(Enemy(1),var(39))                                                    ; 格納IDのキャラクター or Helperが存在する
trigger2   = Abs(PlayerID(Enemy(1),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(1),var(39)),const(size.xscale))       ; 相手の前後85以内
value      = -1
kill       = 0

[State -2:          Power]
type       = PowerAdd
triggerall = !IsHelper
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = GameTime % 2 = 0
triggerall = NumEnemy
trigger1   = Enemy(0),AuthorName = "chikuchikugonzalez" && Enemy(0),Name = "Tohno Akiha"
trigger1   = Enemy(0),var(39) >= 0
trigger1   = PlayerIDExist(Enemy(0),var(39))
trigger1   = Abs(PlayerID(Enemy(0),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(0),var(39)),const(size.xscale))
trigger2   = NumEnemy > 1
trigger2   = Enemy(1),AuthorName = "chikuchikugonzalez" && Enemy(1),Name = "Tohno Akiha"
trigger2   = Enemy(1),var(39) >= 0
trigger2   = PlayerIDExist(Enemy(1),var(39))
trigger2   = Abs(PlayerID(Enemy(1),var(39)),Pos X - Pos X) < (85 * PlayerID(Enemy(1),var(39)),const(size.xscale))
value      = Floor(-1 * (PowerMax * 0.001))

;==============================================================================;
; デバッグ出力
;==============================================================================;
;------------------------------------------------------------------------------;
; AI系
;------------------------------------------------------------------------------;
[State -2:          Debug AI]
type     = DisplayToClipboard
trigger1 = !IsHelper
text     = "AI:%d/%d(%dP)"
params   = var(59), var(58), PalNo

;------------------------------------------------------------------------------;
; 相手位置
;------------------------------------------------------------------------------;
;[State -2:          Debug P2]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;trigger1 = NumEnemy = 1
;text     = " P2Dist:%d x %d P2Vel:%.1f x %.1f DIR:%.2f"
;params   = Ceil(P2BodyDist X), Ceil(P2BodyDist Y), (EnemyNear(0),Vel X), (EnemyNear(0),Vel Y), fvar(30)
;
;[State -2:          Debug P2]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;trigger1 = NumEnemy > 1
;text     = " P2Dist:%d x %d P2Vel:%.1f x %.1f DIR:%.2f"
;params   = Ceil(P2BodyDist X), Ceil(P2BodyDist Y), (EnemyNear(EnemyNear,Alive = 0),Vel X), (EnemyNear(EnemyNear,Alive = 0),Vel Y), fvar(30)
;
;[State -2:          Debug P2 ID]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;text     = " P2ID:%d"
;params   = var(35)

;------------------------------------------------------------------------------;
; フラグ系
;------------------------------------------------------------------------------;
[State -2:          Debug Flags]
type     = AppendToClipboard
trigger1 = !IsHelper
text     = "\nCHAIN:%d SC:%d DC:%d MC:%d"
params   = var(10), var(11), var(12), var(13)

;[State -2:          Debug Blocking]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;text     = "\nSB:%d CB:%d AB:%d BLK:%04X"
;params   = var(16), var(17), var(18), var(15)
;
;[State -2:          Debug Just Defence]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;text     = " JD:%d"
;params   = var(19)

;------------------------------------------------------------------------------;
; 補正
;------------------------------------------------------------------------------;
;[State -2:          Debug Corrections]
;type     = AppendToClipboard
;trigger1 = !IsHelper
;text     = "\nP2COUNT:%d COUNT:%d RATIO:%.2f ATK:%.2f"
;params   = var(36), var(55), fvar(38), fvar(10)


;==============================================================================;
; 常時監視ステート -3
;------------------------------------------------------------------------------;
; 1. 時間停止中も実行される
; 2. 相手にステートを奪われていると実行されない
; 3. Player扱いのヘルパーが参照する
;==============================================================================;
[Statedef -3]

;==============================================================================;
; 特殊カラー処理
;==============================================================================;
[State -2:          No Juggle Check for Gold]
type       = AssertSpecial
triggerall = !IsHelper
trigger1   = PalNo = 12
flag       = NoJuggleCheck

;[State -2:          Life Recovery for Gold]
;type       = LifeAdd
;triggerall = !IsHelper
;triggerall = Life < LifeMax
;triggerall = !IsHelper(6500)
;triggerall = GameTime % 2 = 0
;triggerall = PalNo = 12
;triggerall = RoundState = 2
;trigger1   = Alive
;value      = 1

[State -3:          Power Max for Special Colors]
type       = PowerSet
triggerall = !IsHelper
trigger1   = PalNo = 11
trigger2   = PalNo = 12
value      = PowerMax

[State -3:          Support Level Max for Special Colors]
type       = VarSet
triggerall = !IsHelper
triggerall = var(26) <= 0
trigger1   = PalNo = 11
trigger2   = PalNo = 12
v          = 25
value      = 500

[State -3:          Descendent Support Counter Time for Gold]
type       = VarAdd
triggerall = !IsHelper
triggerall = !NumHelper(6500)
triggerall = var(26) > 0
trigger1   = PalNo = 12
v          = 26
value      = -2

;==============================================================================;
; ユーザーコンフィグ
;==============================================================================;
[State -3:          Call Config Helper]
type       = Helper
triggerall = !IsHelper
triggerall = !NumHelper(9000)
triggerall = RoundState < 2
trigger1   = Alive
helpertype = Normal
name       = "Config"
stateno    = 9000
id         = 9000
postype    = p1
pos        = 0, 0
ownpal     = 0
keyctrl    = 0

;==============================================================================;
; AI起動処理
;==============================================================================;
[State -3:          Call AI Helper]
type          = Helper
triggerall    = !IsHelper
triggerall    = !NumHelper(9999)
triggerall    = RoundState = 2 && Alive
trigger1      = var(59) = 0
trigger1      = var(58) = 0
helpertype    = Normal
name          = "AI Helper"
stateno       = 9999
id            = 9999
keyctrl       = 1
ownpal        = 0
supermovetime = 2147483647
pausemovetime = 2147483647

[State -3:          Get AI Variable]
type           = VarSet
triggerall     = var(58) = 0
trigger1       = NumHelper(9999)
trigger1       = Helper(9999),var(58) != 0
v              = 58
value          = Helper(9999),var(58)
ignorehitpause = 1

[State -3:          Set AI Level (Win)]
type           = VarSet
triggerall     = !IsHelper
trigger1       = !var(59)
trigger1       = var(58) > 0
v              = 59
value          = 3
ignorehitpause = 1

;[State -3:          Set AI Level (1.0)]
;type           = VarSet
;trigger1       = !IsHelper
;;trigger1       = AILevel
;v              = 59
;value          = AILevel        ; from MUGEN rc1
;ignorehitpause = 1

;==============================================================================;
; キャンセルエフェクト
;==============================================================================;
;------------------------------------------------------------------------------;
; スーパーキャンセルエフェクト
;------------------------------------------------------------------------------;
;[State -3:          Super Cancel Helper]
;type          = Helper
;triggerall    = var(11)
;triggerall    = !NumHelper(6600)
;trigger1      = StateNo = 2000
;trigger2      = StateNo = 2010
;helpertype    = Normal
;name          = "Super Cancel"
;stateno       = 6600
;id            = 6600
;postype       = p1
;pos           = 0, 0
;ownpal        = 0
;supermovetime = 2147483647
;pausemovetime = 2147483647

;==============================================================================;
; カットイン
;==============================================================================;
[State -3:          Cut-In, 1]
type          = Helper
triggerall    = !IsHelper
triggerall    = !NumHelper(6900)
triggerall    = !var(53)
trigger1      = NumHelper(6500)
trigger2      = NumHelper(6501)
trigger3      = NumHelper(6502)
helpertype    = Normal
name          = "Cut-In"
stateno       = 6900
id            = 6900
ownpal        = 1
keyctrl       = 0
supermovetime = 2147483647
pausemovetime = 2147483647

;==============================================================================;
; サポートキャラクター
;==============================================================================;
[State -3:          Support Character]
type        = Helper
triggerall  = !IsHelper
triggerall  = RoundState > 0
triggerall  = var(56) = [0, 1]
trigger1    = !NumHelper(20000)
trigger1    = !NumHelper(21000)
helpertype  = Normal
name        = "Support Character"
stateno     = 20000 + var(56) * 1000
id          = 20000 + var(56) * 1000
postype     = p1
pos         = Floor(-60 * const(size.xscale)), 0
ownpal      = 1
keyctrl     = 1
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

[State -3:          Support Gauge]
type          = Helper
triggerall    = !IsHelper
triggerall    = RoundState > 0
triggerall    = !NumHelper(8200)
triggerall    = var(56) = [0, 1]
trigger1      = NumHelper(20000)
trigger2      = NumHelper(21000)
helpertype    = Normal
name          = "Support Gauge"
stateno       = 8200
id            = 8200
postype       = p1
pos           = 0, 0
ownpal        = 0
keyctrl       = 0
size.xscale   = 1.0 ;const(size.xscale)
size.yscale   = 1.0 ;const(size.yscale)
supermovetime = 2147483647
pausemovetime = 2147483647

;==============================================================================;
; 花びら
;==============================================================================;
[State -3:          Petal]
type        = Helper
triggerall  = !IsHelper
trigger1    = StateNo = 210 && (AnimElem = 4 || AnimElem = 5)
trigger2    = StateNo = 215 && (AnimElem = 7 || AnimElem = 8 || AnimElem = 9)
trigger3    = StateNo = 220 && (AnimElem = 4 || AnimElem = 5)
trigger4    = StateNo = 620 && (AnimElem = 5 || AnimElemTime(6) = 1 && !MoveContact)
trigger5    = (StateNo = [1200, 1202]) && (AnimElem = 5 || AnimElem = 7)
trigger6    = (StateNo = [1300, 1301]) && (AnimElem = 4 || AnimElem = 6)
trigger7    = StateNo = 1400 && (AnimElemTime(5) = 4 || AnimElemTime(5) = 8 || AnimElemTime(5) = 12)
trigger8    = (StateNo = [1401, 1402]) && (AnimElem = 10 || AnimElem = 11)
name        = "Petal"
stateno     = 7020
id          = 7020
postype     = p1
pos         = Floor((190 - Random % 160) * const(size.xscale)), Floor((-250 + Random % 60) * const(size.yscale))
ownpal      = 1
facing      = ifelse(Random % 2, -1, 1)
size.xscale = const(size.xscale)
size.yscale = const(size.yscale)

;==============================================================================;
; プロクシガード処理
; ※ プロクシ中は飛び道具に対して無敵にしてみる
;==============================================================================;
;[State -3:          Projectile Not Hit]
;type       = NotHitBy
;triggerall = !IsHelper
;triggerall = NumHelper(20000)
;trigger1   = Helper(20000),StateNo = 20300
;trigger1   = Helper(20000),AnimElemTime(2) < 0
;trigger2   = NumHelper(21500)
;trigger2   = Helper(21500),StateNo = 21520
;trigger2   = Helper(21500),AnimElemTime(2) < 0
;value      = , NP, SP, HP
;time       = 1


;==============================================================================;
; Last Revision : $Rev: 1269 $
; Last Modified : $Date: 2010-12-19 16:18:27 +0900 (日, 19 12 2010) $
;==============================================================================;
